package gov.va.med.domain.service.messaging.decode.hl7.structure;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.model.v24.group.*;

import ca.uhn.hl7v2.model.v24.segment.*;

import ca.uhn.hl7v2.HL7Exception;

import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a ORF_R04 message structure (see chapter 7). This structure contains the 
 * following elements: </p>
 * 0: MSH (Message Header) <b></b><br>
 * 1: MSA (Message Acknowledgment) <b></b><br>
 * 2: ERR (Error) <b>optional </b><br>
 * 3: QAK (Query Acknowledgment) <b>optional </b><br> 
 * 4: QRD (Original-Style Query Definition) <b></b><br>
 * 5: QRF (Original Style Query Filter) <b>optional </b><br>
 * 6: ORF_R04_PIDNTEORCOBRNTECTDOBXNTECTI (a Group object) <b>repeating</b><br>
 * 7: DSC (Continuation Pointer) <b>optional </b><br>
 */
public class ORF_R04 extends AbstractMessage  {

	/** 
	 * Creates a new ORF_R04 Group.
	 */
	public ORF_R04() {
	   try {
	      this.add(MSH.class, true, false);
	      this.add(MSA.class, true, false);
	      this.add(ERR.class, false, false);
	      this.add(QAK.class, false, false);
	      this.add(QRD.class, true, false);
	      this.add(QRF.class, false, false);
	      this.add(ORF_R04_PIDNTEORCOBRNTECTDOBXNTECTI.class, true, true);
	      this.add(DSC.class, false, false);
	   } catch(HL7Exception e) {
	      HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating ORF_R04 - this is probably a bug in the source code generator.", e);
	   }
	}

	/**
	 * Returns MSH (Message Header) - creates it if necessary
	 */
	public MSH getMSH() { 
	   MSH ret = null;
	   try {
	      ret = (MSH)this.get("MSH");
	   } catch(HL7Exception e) {
	      HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
	   }
	   return ret;
	}

	/**
	 * Returns MSA (Message Acknowledgment) - creates it if necessary
	 */
	public MSA getMSA() { 
	   MSA ret = null;
	   try {
	      ret = (MSA)this.get("MSA");
	   } catch(HL7Exception e) {
	      HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
	   }
	   return ret;
	}

	/**
	 * Returns QRD (Original-Style Query Definition) - creates it if necessary
	 */
	public QRD getQRD() { 
	   QRD ret = null;
	   try {
	      ret = (QRD)this.get("QRD");
	   } catch(HL7Exception e) {
	      HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
	   }
	   return ret;
	}

	/**
	 * Returns QRF (Original Style Query Filter) - creates it if necessary
	 */
	public QRF getQRF() { 
	   QRF ret = null;
	   try {
	      ret = (QRF)this.get("QRF");
	   } catch(HL7Exception e) {
	      HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
	   }
	   return ret;
	}

	/**
	 * Returns  first repetition of ORF_R04_PIDNTEORCOBRNTECTDOBXNTECTI (a Group object) - creates it if necessary
	 */
	public ORF_R04_PIDNTEORCOBRNTECTDOBXNTECTI getORF_R04_PIDNTEORCOBRNTECTDOBXNTECTI() { 
	   ORF_R04_PIDNTEORCOBRNTECTDOBXNTECTI ret = null;
	   try {
	      ret = (ORF_R04_PIDNTEORCOBRNTECTDOBXNTECTI)this.get("ORF_R04_PIDNTEORCOBRNTECTDOBXNTECTI");
	   } catch(HL7Exception e) {
	      HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
	   }
	   return ret;
	}

	/**
	 * Returns a specific repetition of ORF_R04_PIDNTEORCOBRNTECTDOBXNTECTI
	 * (a Group object) - creates it if necessary
	 * throws HL7Exception if the repetition requested is more than one 
	 *     greater than the number of existing repetitions.
	 */
	public ORF_R04_PIDNTEORCOBRNTECTDOBXNTECTI getORF_R04_PIDNTEORCOBRNTECTDOBXNTECTI(int rep) throws HL7Exception { 
	   return (ORF_R04_PIDNTEORCOBRNTECTDOBXNTECTI)this.get("ORF_R04_PIDNTEORCOBRNTECTDOBXNTECTI", rep);
	}

	/** 
	 * Returns the number of existing repetitions of ORF_R04_PIDNTEORCOBRNTECTDOBXNTECTI 
	 */ 
	public int getORF_R04_PIDNTEORCOBRNTECTDOBXNTECTIReps() { 
	    int reps = -1; 
	    try { 
	        reps = this.getAll("ORF_R04_PIDNTEORCOBRNTECTDOBXNTECTI").length; 
	    } catch (HL7Exception e) { 
	        String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
	        HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
	        throw new Error(message); 
	    } 
	    return reps; 
	} 

	/**
	 * Returns ERR (Error) - creates it if necessary
	 */
	public ERR getERR() { 
	   ERR ret = null;
	   try {
	      ret = (ERR)this.get("ERR");
	   } catch(HL7Exception e) {
	      HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
	   }
	   return ret;
	}

	/**
	 * Returns QAK (Query Acknowledgment) - creates it if necessary
	 */
	public QAK getQAK() { 
	   QAK ret = null;
	   try {
	      ret = (QAK)this.get("QAK");
	   } catch(HL7Exception e) {
	      HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
	   }
	   return ret;
	}

	/**
	 * Returns DSC (Continuation Pointer) - creates it if necessary
	 */
	public DSC getDSC() { 
	   DSC ret = null;
	   try {
	      ret = (DSC)this.get("DSC");
	   } catch(HL7Exception e) {
	      HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
	   }
	   return ret;
	}

}
